// File: applib.cp
//
// Description: Source code for the OS/2 Presentation
//              Manager Class library.  This library
//              was written using Borland C++ for OS/2 and
//              the IBM First Step development environments.
//
// Copyright 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library
//       may be used in compiled form without restrictions.
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//

#include "applib.h"

const int WIN_HEIGHT = 440;

static int n_m_items;
static char ** m_items;
static char *m_name;

Application::Application(const char * my_class_name,
                         char *menu_name,
                         int num_menu_items,
                         char **menu_items)
                               : class_name(my_class_name)
{   n_m_items = num_menu_items;
    m_items = menu_items;
    m_name = menu_name;
    // Set the static class data:
    sprintf(Application::prompt_for_dialog,
            "%s",
            "Test string for prompt text");
    Application::number_of_dialog_list_items = 0;
}

static int processing = 1;

VOID APIENTRY work_thread(ULONG w)
{
    TAppWindow *aw = (TAppWindow *)w;
    DosSleep(1000);
    while (processing) {
        aw->idle_proc();
        DosSleep(50);
    }
}

int Application::processEventMessages(void)
{
    // Start up a thread to call TAppWindow::idle_proc():
    static TID  t_work;
    DosCreateThread(&t_work,
                    work_thread,
                    (ULONG)Application::get_TAppWindow(),
                    FALSE,
                    64768);   // huge stack for thread!
    while (WinGetMsg(*hand_ab, q_mess, 0, 0, 0))
        WinDispatchMsg(*hand_ab, q_mess);
    processing = 0;
    WinDestroyWindow(*hand_frame);
    WinDestroyMsgQueue(*hand_mq);
    WinTerminate(*hand_ab);
    return 0;
}

//
// Define storage for static class member variables for
// class 'Application':
//

CHAR Application::text_from_dialog[
               Application::DIALOG_TEXT_LENGTH
                                  ] = " ";
int Application::selection_from_dialog = -1;

TAppWindow::TAppWindow(Application * my_application)
{
    if (my_application == NULL)
    {
        Warning("Illegal TAppWindow constructor call");
        exit(1);
    }
    in_scrolling_text_mode = 0;
    redraw_both_text_and_graphics = 1;
    my_owning_application = my_application;
    my_owning_application->set_TAppWindow(this);

    static HAB hand_ab;
    static HMQ hand_mq;
    static HWND hand_frame;

    ULONG flFlags;
    unsigned char win_class[] = "MyClass";
    flFlags = FCF_TITLEBAR | FCF_SIZEBORDER | FCF_MINMAX |
              FCF_SYSMENU  | FCF_VERTSCROLL | FCF_HORZSCROLL |
              FCF_SHELLPOSITION | FCF_MENU;
    hand_ab = WinInitialize(0);
    hand_mq = WinCreateMsgQueue(hand_ab, 0);
    if (!WinRegisterClass(hand_ab,
                          (PSZ)win_class,
                          (PFNWP)window_func,
                          CS_SIZEREDRAW,
                          0))
    {
        Warning("Could not register window class");
        exit(1);
    }
    hand_frame = WinCreateStdWindow(HWND_DESKTOP,
                                    WS_VISIBLE,
                                    &flFlags,
                                    (PSZ)win_class,
                                    (PSZ)"Example", // window
                                                    // title
                                    WS_VISIBLE,
                                    0,
                                    MENU1,
                                    NULL);

    //  Change the menu items text:
    HWND hwndMenu = WinWindowFromID(hand_frame, FID_MENU);
    WinSendMsg(hwndMenu,
               MM_SETITEMTEXT,
               (MPARAM)0,
               (MPARAM)m_name);
    for (int mi=1; mi<(n_m_items + 1); mi++)
        WinSendMsg(hwndMenu,
                   MM_SETITEMTEXT,
                   (MPARAM)mi,
                   (MPARAM)m_items[mi - 1]);

    in_scrolling_text_mode = 0;
    redraw_both_text_and_graphics = 0;
    bottom_text_clip = 0;

    my_owning_application->set_HAB(&hand_ab);
    my_owning_application->set_HMQ(&hand_mq);
    my_owning_application->set_HWND(&hand_frame);

}

//
// User application utility functions:
//

void TAppWindow::plot_line(int x1, int y1, int x2, int y2)
{   POINTL coords;
    coords.x = x1;
    coords.y = WIN_HEIGHT - y1;
    GpiSetCurrentPosition(hps, &coords);
    GpiSetColor(hps, CLR_BLACK);
    coords.x = x2;
    coords.y = WIN_HEIGHT - y2;
    GpiLine(hps, &coords);
}

void TAppWindow::plot_string(int x, int y, char *cp)
{   POINTL pt;
    pt.x = x;
    pt.y = WIN_HEIGHT - y;
    GpiSetBackMix(hps, BM_OVERPAINT);
    GpiCharStringAt(hps, &pt, (LONG)strlen(cp), cp);
}

void TAppWindow::plot_rect(int top, int right,
                           int bottom, int left)
{
    plot_line(left, top, right, top);
    plot_line(right, top, right, bottom);
    plot_line(right, bottom, left, bottom);
    plot_line(left, bottom, left, top);
}

void TAppWindow::erase_rect(int top, int right,
                            int bottom, int left)
{
    RECTL Rect;
    Rect.xLeft = left;
    Rect.yBottom = WIN_HEIGHT - bottom;
    Rect.xRight = right;
    Rect.yTop = WIN_HEIGHT - top;

    WinFillRect(hps, &Rect, CLR_WHITE);
}

void TAppWindow::clear_display()
{
    GpiErase(hps);
    redraw_display();
}

void TAppWindow::redraw_display()
{
    RECTL rcl;
    HWND hWnd =
        *((Application::get_TAppWindow())->get_HWND());
    WinQueryWindowRect(hWnd, &rcl);
    WinInvalidateRect(hWnd, &rcl, FALSE);
}

void TAppWindow::Paint( void )
{
    if (in_scrolling_text_mode == 0 ||
        redraw_both_text_and_graphics == 1) 
    {
       update_display();  // User defined callback
    }
    if (bottom_text_clip > 0  &&
        (in_scrolling_text_mode == 1 ||
         redraw_both_text_and_graphics == 1)) 
    {
        static RECTL Rect;
        Rect.xLeft = left_text_clip+2;
        Rect.yBottom = WIN_HEIGHT - bottom_text_clip-2;
        Rect.xRight = right_text_clip-2;
        Rect.yTop = WIN_HEIGHT - top_text_clip+2;

        HRGN hrgn = GpiCreateRegion(hps, 1L, &Rect);
        LONG rgn_complexity = GpiSetClipRegion(hps, hrgn, NULLHANDLE);

        // Refresh any user scrolling text:
        int next = current_ring_buffer_start;
        for (int i=0; i<number_of_saved_lines; i++) 
        {
            next--;
            if (next < 0) next = number_of_saved_lines - 1;
            plot_string(left_text_clip+3,
                        bottom_text_clip - 4 - i*(string_height(" ")+2),
                        saved_text[next]);
         }
         if (redraw_both_text_and_graphics == 1)
         {
             plot_rect(top_text_clip, right_text_clip - 3,
                       bottom_text_clip, left_text_clip + 2);
         }
         GpiDestroyRegion(hps, hrgn);
    }
}

//
// Default Dialog About box:
//

MRESULT EXPENTRY DefaultAboutBox(HWND hWnd,
                                 ULONG iMessage,
                                 MPARAM param1,
                                 MPARAM param2)
{
    switch (iMessage) {
        case WM_INITDLG:
            WinSetWindowText(WinWindowFromID(hWnd, 102),
                             Application::prompt_for_dialog);
            return (MRESULT)1;
        case WM_COMMAND:
            if (SHORT1FROMMP(param1) == DIALOG_OK) // OK button
            {                                      // clicked
                WinDismissDlg(hWnd, DIALOG_OK);
                break;
            }
            break;
        default:
            return WinDefDlgProc(hWnd, iMessage, param1, param2);
    }
    return (MRESULT) 0;
}

//
// Default Dialog Edit box:
//

MRESULT EXPENTRY DefaultEditBox(HWND hWnd,
                                ULONG iMessage,
                                MPARAM param1,
                                MPARAM param2)
{
    switch (iMessage) {
        case WM_INITDLG:
            WinSetWindowText(WinWindowFromID(hWnd,
                             DIALOG_EDIT_TEXT),
                             Application::text_from_dialog);
            break;
        case WM_COMMAND:
            WinQueryWindowText(WinWindowFromID(hWnd,
                                               DIALOG_EDIT_TEXT),
                               Application::DIALOG_TEXT_LENGTH,
                               Application::text_from_dialog);
            WinDismissDlg(hWnd, DIALOG_OK);
            WinInvalidateRegion(
                *((Application::get_TAppWindow())->get_HWND()),
                NULLHANDLE, FALSE); // redraw window
            break;
        default:
            return WinDefDlgProc(hWnd, iMessage, param1, param2);
    }
}

MRESULT EXPENTRY DefaultListBox(HWND hWnd,
                                ULONG iMessage,
                                MPARAM param1,
                                MPARAM param2)
{   int i;
    static HWND list_box;
    switch (iMessage) {
        case WM_INITDLG:
            list_box = HWNDFROMMP(param1);
            for (i=0;
                 i<Application::number_of_dialog_list_items;
                 i++)
            {
                WinInsertLboxItem(
                    list_box,
                    LIT_END,
                    Application::list_items_for_dialog[i]);
            }
            return (MRESULT) TRUE;

        case WM_CONTROL:
            Application::selection_from_dialog =
                WinQueryLboxSelectedItem(list_box);
            if (Application::selection_from_dialog > -1)
            {
                WinDismissDlg(hWnd, DIALOG_OK);

                WinInvalidateRegion(
                   *((Application::get_TAppWindow())->get_HWND()),
                   NULLHANDLE, FALSE); // redraw window
                return (MRESULT) TRUE;
            }
            // no 'break' since we want default processing:

        default:
            return WinDefDlgProc(hWnd, iMessage, param1, param2);
    }
}

MRESULT EXPENTRY TAppWindow::WndProc(HWND hWnd,
                                     UINT iMessage,
                                     MPARAM param1,
                                     MPARAM param2)
{
    static int mouse_down_flag = 0;
    p_hWnd = &hWnd;
    switch (iMessage)
    {
    // Menu item:
    case WM_COMMAND:
	do_menu_action(SHORT1FROMMP(param1));
	break;
    case WM_CREATE:
        break;
    case WM_PAINT:
        hps = WinBeginPaint(hWnd, (HPS)NULL, &rc);
        WinFillRect(hps, &rc, CLR_WHITE);
        Paint();
        WinEndPaint(hps);
        break;

    case WM_BUTTON1DOWN:  // left button is down
        mouse_down_flag = 1;
        mouse_down(SHORT1FROMMP(param1), 
                   WIN_HEIGHT - SHORT2FROMMP(param1));
        return (MRESULT)TRUE;
        break;
    case WM_MOUSEMOVE:  // left button is down
        if (mouse_down_flag)
           mouse_move(SHORT1FROMMP(param1),
                      WIN_HEIGHT - SHORT2FROMMP(param1));
        return (MRESULT)TRUE;
        break;
    case WM_BUTTON1UP:  // left button is down
        mouse_up(SHORT1FROMMP(param1),
                 WIN_HEIGHT - SHORT2FROMMP(param1));
        mouse_down_flag = 0;
        hps = WinBeginPaint(hWnd, (HPS)NULL, &rc);
        WinFillRect(hps, &rc, SYSCLR_WINDOW);
        Paint();
        WinEndPaint(hps);
        break;
    case WM_ERASEBACKGROUND:
        return (MRESULT)TRUE;
    case WM_DESTROY:
        break;
    default:
        return WinDefWindowProc(hWnd, iMessage,
                                param1, param2 );
    }
    return 0;
}

void TAppWindow::do_about()
{
    HWND *h_frame = my_owning_application->get_HWND();
    WinDlgBox(HWND_DESKTOP, *h_frame, DefaultAboutBox,
              (HMODULE)0, ABOUT_DIALOG, NULL);
}

void TAppWindow::do_edit(char * /* prompt */ , char *buf)
{
    HWND *h_frame = my_owning_application->get_HWND();
    int len = strlen(buf);
    if (len > 255) len = 255;
    for (int i=0; i<len; i++)
        Application::text_from_dialog[i] =
           buf[i]; Application::text_from_dialog[len] = '\0';
    WinDlgBox(HWND_DESKTOP, *h_frame, DefaultEditBox,
              (HMODULE)0, EDIT_DIALOG, NULL);
    for (i=0; Application::text_from_dialog[i] != '\0'; i++)
        buf[i] = Application::text_from_dialog[i];
    buf[i] = '\0';
    return;
}

int TAppWindow::choose_one_from_list(char *prompt,
                                     char **list_items,
                                     int number_of_items)
{
    HWND *h_frame = my_owning_application->get_HWND();
    int theItem = -12;
    Application::number_of_dialog_list_items = number_of_items;
    for (int i=0;
         (i<number_of_items) &&
          (i<Application::DIALOG_MAX_LIST_ITEMS);
         i++)
    {
         Application::list_items_for_dialog[i] = list_items[i];
    }
    WinDlgBox(HWND_DESKTOP, *h_frame, DefaultListBox,
              (HMODULE)0, LIST_DIALOG, NULL);
    return Application::selection_from_dialog;
}

int TAppWindow::choose_one(char *prompt1, char *prompt2)
{
    static char *list[2];
    list[0] = prompt1; list[1] = prompt2;
    return choose_one_from_list("Choose one:", list, 2);
}

MRESULT EXPENTRY window_func(HWND hWnd, ULONG iMessage,
                             MPARAM mp1, MPARAM mp2)
{
    // Pointer to the (C++ object that is the) window.
    TAppWindow *pWindow = Application::get_TAppWindow();
    return pWindow->WndProc(hWnd, iMessage, mp1, mp2);
}


void TAppWindow::init_scrolling_text(int top, int right,
                                     int bottom, int left)
{
    top_text_clip = top;
    right_text_clip = right;
    bottom_text_clip = bottom;
    left_text_clip = left;
    number_of_saved_lines =
        1+((bottom_text_clip-top_text_clip)/string_height(" "));
    if (number_of_saved_lines < 4)
       number_of_saved_lines = 4;
    if (number_of_saved_lines > MAX_TEXT_LINES)
       number_of_saved_lines = MAX_TEXT_LINES;
    current_ring_buffer_start = 0;
    // Allocate storage for saved text lines:
    for (int i=0; i<number_of_saved_lines; i++)  {
      saved_text[i] = new char[MAX_TEXT_LINE_SIZE];
      saved_text[i][0] = '\0';
    }
    in_scrolling_text_mode = 1;
    redraw_both_text_and_graphics = 1;
}

void TAppWindow::init_scrolling_text()
{
    top_text_clip = 5;
    right_text_clip = 512;
    bottom_text_clip = 300;
    left_text_clip = 5;
    number_of_saved_lines =
       1+((bottom_text_clip-top_text_clip)/string_height(" "));
    if (number_of_saved_lines > MAX_TEXT_LINES)
       number_of_saved_lines = MAX_TEXT_LINES;
    current_ring_buffer_start = 0;
    // Allocate storage for saved text lines:
    for (int i=0; i<number_of_saved_lines; i++) 
    {
      saved_text[i] = new char[MAX_TEXT_LINE_SIZE+1];
      saved_text[i][0] = '\0';
    }
    in_scrolling_text_mode = 1;
    redraw_both_text_and_graphics = 0;
}

void TAppWindow::put_scrolling_text(char *str)
{
    if (strlen(str) < 256)
    {
       char buf[257];
       sprintf(buf,"%s",str);
       buf[MAX_TEXT_LINE_SIZE] = '\0';
       saved_text[current_ring_buffer_start][0]='\0';
       strcat(saved_text[current_ring_buffer_start], buf);
       current_ring_buffer_start++;
       if (current_ring_buffer_start > (number_of_saved_lines - 1))
          current_ring_buffer_start = 0;
    }  else {
       Warning("Need to call TAppWindow::init_scrolling_text.");
    }
    WinInvalidateRegion(
       *((Application::get_TAppWindow())->get_HWND()),
       NULLHANDLE, FALSE); // redraw window
}

void TAppWindow::reset_scrolling_text()
{
    for (int i=0; i<MAX_TEXT_LINES; i++) saved_text[i][0] = '\0';
}

int TAppWindow::file_chooser_helper(char *prompt,
                                    char *extension,
                                    char *returned_filename)
{
    //
    // Based on the "jigsaw" example program from IBM:
    //

    FILEDLG     fileDialog;
    fileDialog.cbSize = sizeof(FILEDLG);
    fileDialog.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    fileDialog.pszTitle = (PSZ)prompt;
    fileDialog.pszOKButton = (PSZ)"Enter";

    fileDialog.ulUser = 0L;     \
    // Use the default file dialog proc:
    fileDialog.pfnDlgProc = (PFNWP)WinDefFileDlgProc;
    fileDialog.lReturn = 0L;
    fileDialog.lSRC = 0;
    fileDialog.hMod = 0;
    fileDialog.usDlgId = 0;
    fileDialog.x = 0;
    fileDialog.y = 0;
    fileDialog.pszIType = (PSZ)NULL;  // Extended Attribute
                                      // type list
    static PSZ apszITL[]={(PSZ)NULL}; // initial type
    fileDialog.papszITypeList = (PAPSZ)apszITL;
    fileDialog.pszIDrive = (PSZ)NULL;  // disk drive list
    fileDialog.papszIDriveList = (PAPSZ)NULL; // initial drive
    fileDialog.sEAType = -1;
    fileDialog.papszFQFilename = 0;
    fileDialog.ulFQFCount = 0;

    // Build a pattern match string from the desired
    // file extension:
    sprintf(fileDialog.szFullFile, "*.%s", extension);

    // Get a handle to the current application's window frame:
    HWND *h_frame = my_owning_application->get_HWND();

    // Use the OS/2 file selection utility
    // function 'WinFileDlg':
    if (!WinFileDlg(HWND_DESKTOP,
                    *h_frame,
                    (PFILEDLG)&fileDialog))
    {
       Warning("Did not select a file");
       return 1;   // Error
    }
    if (fileDialog.lReturn == DID_OK) {
       sprintf(returned_filename,"%s", fileDialog.szFullFile);
       return 0;   // OK
    }
    return 1;      // Error
}

int TAppWindow::choose_file_to_read(char *prompt,
                                    char *extension,
                                    char *returned_filename)
{

     return file_chooser_helper(prompt,
                                extension,
                                returned_filename);
}
int TAppWindow::choose_file_to_write(char *prompt,
                                    char *returned_filename)
{
     return file_chooser_helper(prompt,
                                "*",
                                returned_filename);
}

void Warning(char *buf)
{
    TAppWindow * current_window = Application::get_TAppWindow();
    if (current_window != 0)
       current_window->do_edit(" ", buf);
}

void Warning(char *buf, int num)
{
    TAppWindow * current_window = Application::get_TAppWindow();
    static char buffer[128];
    sprintf(buffer, buf, num);
    if (current_window != 0)
        current_window->do_edit(" ", buffer);
}

// Allocate storage for static class variables:

TAppWindow * Application::app_window = (TAppWindow *)NULL;
CHAR Application::prompt_for_dialog[
                Application::DIALOG_TEXT_LENGTH];
CHAR Application::file_extension_for_dialog[
                Application::DIALOG_TEXT_LENGTH];
CHAR * Application::list_items_for_dialog[
                Application::DIALOG_MAX_LIST_ITEMS];
int Application::number_of_dialog_list_items;

